错误诊断

如果出现不理想的操作行为，可能需要进行扩展诊断。可以通过查看ACP服务的错误代号查看，详情可见下：

\#ifndef LIBACP\_LIBACPERR\_H\_

\#define LIBACP\_LIBACPERR\_H\_

enum AcpErrors {

&#x20; ACP\_ERR\_SUCCESS = 0x0000,



&#x20; // 通讯状态的变化

&#x20; ACP\_ERR\_CONN\_SUCCESS = 0x0001,     // 连接成功

&#x20; ACP\_ERR\_CONN\_PENDING = 0x0002,     // 正在连接

&#x20; ACP\_ERR\_NO\_CONN = 0x0003,          // 未连接

&#x20; ACP\_ERR\_CONN\_REFUSED = 0x0004,     // 拒绝连接

&#x20; ACP\_ERR\_CONN\_LOST = 0x0005,        // 断开连接

&#x20; ACP\_ERR\_CONN\_TIMEOUT = 0x0006,     // 连接超时

&#x20; ACP\_ERR\_HOSTUNREACHABLE = 0x0007,  // Host unreachable

&#x20; ACP\_ERR\_AUTH\_CONTINUE = 0x0008,    // 需要权限认证

&#x20; // 基础通讯协议类的错误

&#x20; ACP\_ERR\_INVALID\_ACPDEVICEID = 0x1001,  // 无效的AcpDeviceId

&#x20; ACP\_ERR\_INVAILD\_IDGROUP,               // 无效的id group

&#x20; ACP\_ERR\_INVAILD\_IDOFFSET,              // 无效的id offset

&#x20; ACP\_ERR\_INVAILD\_DATAPACKAGE\_LEN,       // 无效的数据包长度

&#x20; ACP\_ERR\_INVAILD\_PORT,                  // 无效的port port号1-65535

&#x20; ACP\_ERR\_PORT\_UNREGISTER,               // 路由port未注册

&#x20; ACP\_ERR\_PORT\_ALREADY\_REGISTER,          // 路由port号已经被注册了

&#x20; ACP\_ERR\_MESSAGE\_TIMEOUT,               // 消息超时

&#x20; ACP\_ERR\_UNKNOWN\_CMDID,                 // 未知的CmdId

&#x20; ACP\_ERR\_UNKNOWN\_TOPIC,                 // 未知的topic

&#x20; ACP\_ERR\_NOSUPPORT\_CONNPROTOCOL,        // 不支持的通讯协议

&#x20; ACP\_ERR\_DATAPACKAGE\_TOO\_SMALL,         // 数据包长度太小了

&#x20; ACP\_ERR\_DATAPACKAGE\_TOO\_LONG,          // 数据包长度太大了

&#x20; ACP\_ERR\_SERIALIZED,                    // 序列化错误

&#x20; ACP\_ERR\_DESERIALIZED,                  // 反序列化错误

&#x20; ACP\_ERR\_HEADER\_LEN\_NOT\_MATCH,          // acp header长度不匹配



&#x20; // 内部API使用的相关错误码

&#x20; ACP\_ERR\_INVAILD\_HANDLER = 0x2001,  // 无效的句柄

&#x20; ACP\_ERR\_INVAILD\_NETADAPTER,        // 无效的网络适配器

&#x20; ACP\_ERR\_INIT\_RESOURCE\_ERROR,       // 初始化资源错误

&#x20; ACP\_ERR\_INVAILD\_INPUT\_PARAM,       // 无效的输入参数

&#x20; ACP\_ERR\_SERVER\_NOT\_RUNING,         // ACP服务未运行

&#x20; ACP\_ERR\_INVAILD\_REQ\_CMD,           // 无效的请求命令

&#x20; ACP\_ERR\_INVAILD\_BUFF\_LENGTH,       // 无效的buff的长度

&#x20; ACP\_ERR\_NOMEMORY,                  // 没有足够内存

&#x20; ACP\_ERR\_NO\_DISK\_SPACE,             // 没有足够的磁盘空间

&#x20; // 文件传输错误码

&#x20; ACP\_ERR\_FILESYSTEM\_CREATEFILE\_FAIL = 0x3000,  // 创建文件失败

&#x20; ACP\_ERR\_FILESYSTEM\_FILEOPEN\_FAIL,             // 文件打开失败

&#x20; ACP\_ERR\_FILESYSTEM\_FILE\_NO\_EXIST,             // 文件不存在

&#x20; ACP\_ERR\_FILESYSTEM\_FILEREAD\_FAIL,             // 读文件错误

&#x20; ACP\_ERR\_FILESYSTEM\_FILEWRITE\_FAIL,            // 写文件错误

&#x20; ACP\_ERR\_FILESYSTEM\_INVAILD\_HANDLER,           // 无效的文件句柄

&#x20; ACP\_ERR\_FILESYSTEM\_TRANSFER\_FAULT,            // 传输错误

&#x20; // 组件相关的错误码

&#x20; ACP\_ERR\_CMP\_UNREGISTER = 0X4001,     // 组件位注册

&#x20; ACP\_ERR\_CMP\_CONN\_ACPSERVER\_TIMEOUT,  // 连接服务超时

&#x20; ACP\_ERR\_CMP\_ALREADY\_REGISTER,        // 组件已经注册

};

\#endif  // LIBACP\_LIBACPERR\_H\_

## 二、功能介绍

#### **枚举、结构体及部分类型数据说明**

**ATTRIB**

枚举变量，定义了文件的特征，用于给GetAttribute功能块提供返回值

![](images/image53.png)

**ERROR**

枚举变量，整个库中可能出现的故障定义

![](images/image54.png)

**MODE**

枚举变量，定义了Open功能块中，文件打开的方式

![](images/image55.png)

**FILE\_DIR\_ENTRY**

结构体变量，保存了目录下每个条目的信息，通过顺序调用DirList来填写

![](images/image56.png)

T\_FILENAME

TYPE T\_FILENAME: STRING(255)

T\_HANDLE

TYPE T\_HANDLE: ULINT

T\_SIZE

TYPE T\_SIZE : UDINT

T\_PVOID

TYPE T\_PVOID: ULINT













#### **目录类(Directory)**

**DirOpen**

打开一个目录，返回的句柄后续使用的时候都需要用到，如果需要获得目录内的条目，需要调用DirList，一个一个获得

![](images/image57.png)

**DirClose**

关闭一个目录

![](images/image58.png)

**DirList**

读取目录条目，每次读取一条，读取的内容存储在结构体中

![](images/image59.png)





**DirCreate**

创建一个子目录

![](images/image60.png)

**DirCopy**

拷贝目录，可以通过参数指定是否拷贝子目录或者是否覆盖

![](images/image61.png)

**DirRename**

重命名一个目录（不建议用此功能移动文件，可以使用Rename）

![](images/image62.png)



**DirRemove**

删除一个目录（可能有文件已经被Open打开）

![](images/image63.png)

#### **文件类(File)**

**FileOpen**

打开一个文件，生成一个句柄，可以用于Read、Write、Close（xExclusive参数codesys不支持）

![](images/image64.png)







**FileClose**

关闭文件句柄

![](images/image65.png)

**FileRead**

读取数据到buffer中

![](images/image66.png)

**FileWrite**

将buffer写入文件中

![](images/image67.png)

**FileCopy**

拷贝文件，如果不存在则创建，存在根据参数可以选择覆盖

![](images/image68.png)

**FileDelete**

删除文件，如果Open也会被删除

![](images/image69.png)

**FileRename**

重命名文件，也可以用于移动文件，不能用于移动目录

![](images/image70.png)



**FileSetPos**

移动当前打开文件的读写位置

![](images/image71.png)

**FileGetPos**

读取当前打开文件的读写位置

![](images/image72.png)

**FileEOF**

用于判断当前读写位置是否已经到文件末尾

![](images/image73.png)











**FileFlush**

强制将缓冲区内的数据写入到磁盘中

![](images/image74.png)

**FileGetAttribute**

获得当前打开文件的文件属性，文件属性的定义位于枚举变量ATTRIB

![](images/image75.png)

**FileGetSize**

获取文件名指向文件的文件大小

![](images/image76.png)











**FileGetTime**

获取文件名指向文件的最新修改日期

![](images/image77.png)

#### **函数类**

GetLibVersion

功能描述：返回当前版本信息

Return：（VERSION）返回当前版本信息

## 三、支持与服务

中科时代为公司产品及解决方案提供全方位支持与服务，确保针对相关问题给予快速且专业的响应。

**资料下载**

我们的资料下载专区涵盖了丰富的文件资源，包括应用案例、技术文档、产品介绍等，满足您的多样化需求。

资料下载地址：<https://help.sinsegye.com.cn/>

**获取支持**

如需中科时代产品的本地支持与服务，请随时联系我们。您可以通过访问我们的官方网站www.sinsegye.com.cn，查找中科时代的分公司地址，并获取更多关于中科时代的信息。

此外，您还可以通过以下方式联系我们：

* 热线电话：400-013-2158

* 邮箱地址：support@sinsegye.com.cn